/**
 * \file: SensorSourceChannel.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: AAuto
 *
 * \author: M. Adachi / ADITJ/SW / madachi@jp.adit-jv.com
 *
 * \copyright (c) 2013-2014 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef AAUTO_SENSORSOURCE_CHANNEL_H
#define AAUTO_SENSORSOURCE_CHANNEL_H

#include <adit_logging.h>
#include <string>
#include <VirtualSensorSource.h>

/* GalReceiver headers */
#include <aauto/GalReceiver.h>
#include <aauto/util/shared_ptr.h>
#include <aauto/SensorSource.h>

namespace adit { namespace aauto {

class SensorSourceChannel
{
public:
    SensorSourceChannel(::shared_ptr<GalReceiver> inReceiver, uint8_t inSessionId, uint32_t inLocationCharacterization);
    virtual ~SensorSourceChannel();
    bool Initialize(std::string inTestLocation);
    void shutdown();
    void sensorWork(SensorType type);
    void sensorBreak(SensorType type);

private:
    uint8_t sessionId;
    ::shared_ptr<GalReceiver> receiver;
    ::shared_ptr<VirtualSensorSource> vsensor;

    uint32_t mLocationCharacterization;
};

} } /* namespace adit { namespace aauto */

#endif /* AAUTO_SENSORSOURCE_CHANNEL_H */
